/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import io.flutter.Log;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import java.util.HashSet;
import java.util.Set;

public class FlutterTextureView
extends TextureView
implements FlutterRenderer.RenderSurface {
    private static final String TAG = "FlutterTextureView";
    private boolean isSurfaceAvailableForRendering = false;
    private boolean isAttachedToFlutterRenderer = false;
    @Nullable
    private FlutterRenderer flutterRenderer;
    @NonNull
    private Set<OnFirstFrameRenderedListener> onFirstFrameRenderedListeners = new HashSet<OnFirstFrameRenderedListener>();
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            Log.v(FlutterTextureView.TAG, "SurfaceTextureListener.onSurfaceTextureAvailable()");
            FlutterTextureView.this.isSurfaceAvailableForRendering = true;
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.connectSurfaceToRenderer();
            }
        }

        public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
            Log.v(FlutterTextureView.TAG, "SurfaceTextureListener.onSurfaceTextureSizeChanged()");
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.changeSurfaceSize(width, height);
            }
        }

        public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
        }

        public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
            Log.v(FlutterTextureView.TAG, "SurfaceTextureListener.onSurfaceTextureDestroyed()");
            FlutterTextureView.this.isSurfaceAvailableForRendering = false;
            if (FlutterTextureView.this.isAttachedToFlutterRenderer) {
                FlutterTextureView.this.disconnectSurfaceFromRenderer();
            }
            return true;
        }
    };

    public FlutterTextureView(@NonNull Context context) {
        this(context, null);
    }

    public FlutterTextureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setSurfaceTextureListener(this.surfaceTextureListener);
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        Log.v(TAG, "Attaching to FlutterRenderer.");
        if (this.flutterRenderer != null) {
            Log.v(TAG, "Already connected to a FlutterRenderer. Detaching from old one and attaching to new one.");
            this.flutterRenderer.detachFromRenderSurface();
        }
        this.flutterRenderer = flutterRenderer;
        this.isAttachedToFlutterRenderer = true;
        if (this.isSurfaceAvailableForRendering) {
            Log.v(TAG, "Surface is available for rendering. Connecting FlutterRenderer to Android surface.");
            this.connectSurfaceToRenderer();
        }
    }

    @Override
    public void detachFromRenderer() {
        if (this.flutterRenderer != null) {
            if (this.getWindowToken() != null) {
                Log.v(TAG, "Disconnecting FlutterRenderer from Android surface.");
                this.disconnectSurfaceFromRenderer();
            }
            this.flutterRenderer = null;
            this.isAttachedToFlutterRenderer = false;
        } else {
            Log.w(TAG, "detachFromRenderer() invoked when no FlutterRenderer was attached.");
        }
    }

    private void connectSurfaceToRenderer() {
        if (this.flutterRenderer == null || this.getSurfaceTexture() == null) {
            throw new IllegalStateException("connectSurfaceToRenderer() should only be called when flutterRenderer and getSurfaceTexture() are non-null.");
        }
        this.flutterRenderer.surfaceCreated(new Surface(this.getSurfaceTexture()));
    }

    private void changeSurfaceSize(int width, int height) {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("changeSurfaceSize() should only be called when flutterRenderer is non-null.");
        }
        Log.v(TAG, "Notifying FlutterRenderer that Android surface size has changed to " + width + " x " + height);
        this.flutterRenderer.surfaceChanged(width, height);
    }

    private void disconnectSurfaceFromRenderer() {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("disconnectSurfaceFromRenderer() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.surfaceDestroyed();
    }

    @Override
    public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.onFirstFrameRenderedListeners.add(listener);
    }

    @Override
    public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.onFirstFrameRenderedListeners.remove(listener);
    }

    @Override
    public void onFirstFrameRendered() {
        Log.v(TAG, "onFirstFrameRendered()");
        for (OnFirstFrameRenderedListener listener : this.onFirstFrameRenderedListeners) {
            listener.onFirstFrameRendered();
        }
    }
}

