/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.cloud.msc.f;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.iflytek.cloud.SpeechError;
import com.iflytek.cloud.SpeechUtility;
import java.io.IOException;
import java.util.HashSet;

public abstract class a
extends Handler {
    protected static final int MSG_START = 0;
    protected static final int MSG_SESSION_BEGIN = 1;
    protected static final int MSG_RECORD_AUDIO = 2;
    protected static final int MSG_RECORD_STOPD = 3;
    protected static final int MSG_RESULT = 4;
    protected static final int MSG_TTS_AUDIO = 5;
    protected static final int MSG_NET_PERF = 7;
    protected static final int MSG_NET_TIMEOUT = 8;
    protected static final int MSG_SPEECH_TIMEOUT = 9;
    protected static final int MSG_UPLOAD = 10;
    protected static final int MSG_DOWNLOAD = 11;
    protected static final int MSG_SEARCH = 12;
    protected static final int MSG_ISV_REQUEST = 13;
    protected static final int MSG_CLEAR = 20;
    protected static final int MSG_END = 21;
    protected static final int MSG_REQUEST_RESULT = 22;
    public static final String TAG_UPFLOW = "upflow";
    public static final String TAG_DOWNFLOW = "downflow";
    public static final String TAG_LOGIN_ID = "loginid";
    public static final String TAG_NETPERF = "netperf";
    protected int mSpeechTimeOut = 60000;
    public int mSampleRate = 16000;
    protected Context mContext = null;
    private com.iflytek.cloud.a.a mParam = new com.iflytek.cloud.a.a();
    protected volatile boolean mUserCancel = false;
    private volatile b mStatus = b.a;
    protected long mStatusBegin = 0L;
    protected int mNetTimeOut = 20000;
    private HandlerThread mThread;
    protected static final HashSet<a> sInstances = new HashSet();

    public a(Context context, HandlerThread handlerThread) {
        super(handlerThread.getLooper());
        this.mThread = handlerThread;
        this.mContext = context;
        this.mUserCancel = false;
        sInstances.add(this);
    }

    public a(Context context) {
        super(context.getMainLooper());
        this.mContext = context;
        this.mUserCancel = false;
    }

    protected void onMsgProcess(Message message) throws Throwable, SpeechError {
    }

    protected void updateTimeoutMsg() {
        this.removeMessages(8);
        this.sendMsg(8, a.b, false, this.mNetTimeOut);
    }

    private void destroyThread() {
        if (null != this.mThread && this.mThread.isAlive()) {
            this.clearAllMsg();
            Thread thread = null;
            Looper looper = null;
            if (null != this.mContext && null != (looper = this.mContext.getMainLooper())) {
                thread = looper.getThread();
            }
            if (null == this.mContext || !this.mThread.equals(thread)) {
                this.mThread.quit();
                com.iflytek.cloud.msc.i.b.a.a("quit current Msc Handler thread");
            }
            this.mThread = null;
        }
        sInstances.remove((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message) {
        switch (message.what) {
            case 21: {
                this.onEnd((SpeechError)message.obj);
                this.destroyThread();
                break;
            }
            default: {
                SpeechError speechError = null;
                try {
                    switch (message.what) {
                        case 8: {
                            throw new SpeechError(20002);
                        }
                    }
                    if (null == SpeechUtility.getUtility() && 1 == message.what) {
                        com.iflytek.cloud.msc.i.b.a.c("SDK is not init while session begin");
                        throw new SpeechError(20015);
                    }
                    this.onMsgProcess(message);
                    break;
                }
                catch (IOException iOException) {
                    com.iflytek.cloud.msc.i.b.a.a(iOException);
                    speechError = new SpeechError(20010);
                    break;
                }
                catch (SpeechError speechError2) {
                    com.iflytek.cloud.msc.i.b.a.a(speechError2);
                    speechError = speechError2;
                    break;
                }
                catch (Exception exception) {
                    com.iflytek.cloud.msc.i.b.a.a(exception);
                    speechError = new SpeechError(exception);
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    com.iflytek.cloud.msc.i.b.a.a(unsatisfiedLinkError);
                    speechError = new SpeechError(20021);
                    break;
                }
                catch (Throwable throwable) {
                    com.iflytek.cloud.msc.i.b.a.a(throwable);
                    speechError = new SpeechError(20999);
                    break;
                }
                finally {
                    if (speechError != null) {
                        com.iflytek.cloud.msc.i.b.a.a(this.getTag() + " occur Error = " + speechError.toString());
                        this.exit(speechError);
                    }
                }
            }
        }
    }

    public boolean isLongInput() {
        return false;
    }

    public String getParamEncoding() {
        return this.mParam.b("pte", "utf-8");
    }

    public String getTextEncoding() {
        return this.mParam.b("text_encoding", "utf-8");
    }

    public String getResultEncoding() {
        return this.mParam.b("rse", "utf-8");
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public void cancel(boolean bl) {
        this.mUserCancel = true;
        this.clearAllMsg();
        this.exit(null);
    }

    protected synchronized void exit(SpeechError speechError) {
        if (speechError != null) {
            this.clearAllMsg();
        }
        this.sendMsg(this.obtainMessage(21, speechError));
    }

    public static boolean isEmpty() {
        return sInstances.isEmpty();
    }

    public boolean isRunning() {
        return this.mStatus != b.f && this.mStatus != b.e && this.mStatus != b.a;
    }

    protected synchronized void setStatus(b b2) {
        com.iflytek.cloud.msc.i.b.a.a("curStatus=" + (Object)((Object)this.mStatus) + ",setStatus=" + (Object)((Object)b2));
        if (this.mStatus == b.f) {
            return;
        }
        if (this.mStatus == b.e && b2 != b.f) {
            return;
        }
        com.iflytek.cloud.msc.i.b.a.a("setStatus success=" + (Object)((Object)b2));
        this.mStatus = b2;
        this.mStatusBegin = SystemClock.elapsedRealtime();
    }

    protected synchronized b getStatus() {
        return this.mStatus;
    }

    public abstract String getSessionID();

    public abstract String getClientID();

    protected void setParams(com.iflytek.cloud.a.a a2) {
        this.mParam = a2.b();
        this.onParseParam();
    }

    protected void onParseParam() {
        this.mNetTimeOut = this.mParam.a("timeout", this.mNetTimeOut);
        this.mSampleRate = this.mParam.a("sample_rate", this.mSampleRate);
    }

    public com.iflytek.cloud.a.a getParam() {
        return this.mParam;
    }

    protected void start() {
        this.sendMsg(0, a.a, false, 0);
    }

    protected void sendMsg(int n) {
        this.sendMsg(this.obtainMessage(n), a.b, false, 0);
    }

    protected void sendMsg(Message message) {
        this.sendMsg(message, a.b, false, 0);
    }

    protected void sendMsg(int n, a a2, boolean bl, int n2) {
        this.sendMsg(this.obtainMessage(n), a2, bl, n2);
    }

    protected void sendMsg(Message message, a a2, boolean bl, int n) {
        if (this.getStatus() == b.f || this.getStatus() == b.e) {
            com.iflytek.cloud.msc.i.b.a.a("send msg failed while status is " + (Object)((Object)this.getStatus()));
            return;
        }
        switch (message.what) {
            case 0: {
                this.setStatus(b.b);
                break;
            }
            case 3: {
                this.setStatus(b.d);
                break;
            }
            case 21: {
                this.setStatus(b.e);
                break;
            }
        }
        if (bl) {
            this.removeMessages(message.what);
        }
        if (a2 == a.a && n <= 0) {
            this.sendMessageAtFrontOfQueue(message);
        } else {
            this.sendMessageDelayed(message, n);
        }
    }

    protected void clearAllMsg() {
        com.iflytek.cloud.msc.i.b.a.a("clear all message");
        for (int i2 = 0; i2 < 20; ++i2) {
            this.removeMessages(i2);
        }
    }

    protected void onEnd(SpeechError speechError) {
        this.setStatus(b.f);
        this.clearAllMsg();
    }

    protected String getTag() {
        return ((Object)((Object)this)).getClass().toString();
    }

    public static void timeOutCheck(long l2, int n) throws SpeechError {
        if (SystemClock.elapsedRealtime() - l2 > (long)n) {
            throw new SpeechError(20002);
        }
    }

    public void startBluetooth() throws SecurityException {
        com.iflytek.cloud.msc.i.b.a.a("startBluetooth enter");
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        audioManager.setBluetoothScoOn(true);
        audioManager.startBluetoothSco();
    }

    public void stopBluetooth() {
        com.iflytek.cloud.msc.i.b.a.a("stopBluetooth enter");
        try {
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            audioManager.setBluetoothScoOn(false);
            audioManager.stopBluetoothSco();
        }
        catch (SecurityException securityException) {
            com.iflytek.cloud.msc.i.b.a.a(securityException);
        }
        catch (Throwable throwable) {
            com.iflytek.cloud.msc.i.b.a.a(throwable);
        }
    }

    protected static enum a {
        a,
        b;

    }

    protected static enum b {
        a,
        b,
        c,
        d,
        e,
        f;

    }
}

