/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.cloud.msc.ist;

import android.content.Context;
import android.os.Bundle;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.iflytek.cloud.SpeechError;
import com.iflytek.cloud.TranscripterListener;
import com.iflytek.cloud.TranscripterResult;
import com.iflytek.cloud.a.a;
import com.iflytek.cloud.a.b;
import com.iflytek.cloud.msc.f.a;
import com.iflytek.cloud.msc.f.b;
import com.iflytek.cloud.msc.f.c;
import com.iflytek.cloud.msc.i.k;
import com.iflytek.cloud.msc.ist.AudioAccessor;
import com.iflytek.cloud.msc.ist.IstSession;
import com.iflytek.cloud.record.PcmRecorder;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MscTranscripter
extends com.iflytek.cloud.msc.f.a
implements PcmRecorder.PcmRecordListener {
    protected volatile TranscripterListener mListener = null;
    protected boolean mFirstRecordAudio = false;
    protected boolean mFirstDataWrite = false;
    protected boolean mFirstDataArrival = false;
    protected boolean mUstopRecord = false;
    protected int mAudioSource = 1;
    protected IstSession mSession = new IstSession();
    protected PcmRecorder mRecorder = null;
    public static int mUpflow = 0;
    public static int mDownflow = 0;
    protected ArrayList<String> mResults = null;
    private byte[] mBuffer = null;
    private int mLastMscOffset = 0;
    private int mLastServerOffset = 0;
    private int mResultSecondLeft = -1;
    private String mSessionID = null;
    private int mSyncID = 0;
    private String mFilePath = null;
    private AudioAccessor mAccesser = null;
    private final String KEY_TOTAL_AUDIO = "total";
    private int mMaxSessionTry = 1;
    private final int SESSION_RETRY_PERIOD = 500;
    protected static final int MSG_CUSTOM_MIN = 32789;
    private static final int MSG_WAIT_RESULT = 32790;
    private static final int WAIT_RESULT_PERIOD = 500;
    private static final int STATUS_NORESULT = 2;
    private static final int STATUS_HASRESULT = 0;
    private static final int STATUS_LASTRESULT = 5;
    private boolean mIsProcRecordDataOn = false;
    private boolean mIsRecording = false;
    private SpeechError mError = null;
    private boolean mIsFirstSession = true;
    private boolean mIsRestarting = false;
    private static final int NET_PERF_MSG_DELAY = 500;
    private boolean mUseBluetooth = false;
    protected c mPerflog = new c();
    private int mSessionRetryCount = 0;

    public MscTranscripter(Context context, a a2, HandlerThread handlerThread) {
        super(context, handlerThread);
        this.mResults = new ArrayList();
        this.setParams(a2);
    }

    public int getAudioSource() {
        return this.mAudioSource;
    }

    public void callbackVolume(byte[] byArray, int n) {
        if (this.isRunning()) {
            this.mListener.onVolumeChanged(n, byArray);
        }
    }

    public synchronized void startTranscripting(TranscripterListener transcripterListener) {
        this.mListener = transcripterListener;
        com.iflytek.cloud.msc.i.b.a.a("startTranscripting called");
        this.start();
    }

    @Override
    protected void start() {
        this.mPerflog.a(this.getParam());
        super.start();
    }

    @Override
    protected void onMsgProcess(Message message) throws Throwable, SpeechError {
        super.onMsgProcess(message);
        if (0 != message.what && !this.isRunning()) {
            return;
        }
        switch (message.what) {
            case 0: {
                this.proc_Msg_Start();
                break;
            }
            case 1: {
                this.proc_Msg_Session_Begin();
                break;
            }
            case 2: {
                this.proc_Msg_Record_Data(message);
                break;
            }
            case 3: {
                this.proc_Msg_Record_Stoped();
                break;
            }
            case 32790: {
                this.proc_Msg_Wait_Result();
                break;
            }
            case 4: {
                this.proc_Msg_Result(message);
                break;
            }
            case 7: {
                this.proc_Msg_Netperf();
                break;
            }
            case 22: {
                this.requestResult();
                break;
            }
        }
    }

    protected void proc_Msg_Start() throws Exception {
        com.iflytek.cloud.msc.i.b.a.a("start connecting");
        String string = this.getParam().e("engine_type");
        if ("cloud".equals(string) && (-1 == this.getAudioSource() || -2 == this.getAudioSource())) {
            k.b(this.mContext);
        }
        int n = this.getParam().a("record_read_rate", 40);
        if (-1 == this.mAudioSource) {
            this.mAccesser = AudioAccessor.createBufferAccessor();
        } else if (-2 == this.mAudioSource) {
            this.mAccesser = AudioAccessor.createReadOnlyAccessor(this.mFilePath);
            this.getParam().a("sample_rate", this.mAccesser.getAudioInfo(AudioAccessor.AudioKeys.RATE), false);
        } else {
            this.mAccesser = AudioAccessor.createWriteReadAccessor(this.mFilePath, this.mSampleRate);
            if (null != this.mListener) {
                Bundle bundle = new Bundle();
                bundle.putString("ist_audio_path", this.mAccesser.getFilePath());
                this.mListener.onEvent(10004, 0, 0, bundle);
            }
        }
        this.mBuffer = new byte[this.mAccesser.getBufferLength()];
        if (this.mAudioSource >= 0 && this.isRunning()) {
            com.iflytek.cloud.msc.i.b.a.a("start  record");
            this.mUseBluetooth = this.getParam().a("bluetooth", this.mUseBluetooth);
            if (this.mUseBluetooth) {
                this.startBluetooth();
            }
            this.mRecorder = new PcmRecorder(this.getSampleRate(), n, this.mAudioSource);
            this.mPerflog.a("rec_open");
            this.mRecorder.startRecording(this);
            if (null != this.mListener) {
                this.mListener.onBeginOfSpeech();
            }
        }
        this.mPerflog.a("app_ssb");
        this.sendMsg(1, a.a.a, false, 0);
        this.mIsRecording = true;
    }

    protected void proc_Msg_Session_Begin() throws Exception {
        if (this.isSessionOn()) {
            return;
        }
        this.assertSessionTimes();
        int n = 0;
        try {
            com.iflytek.cloud.msc.i.b.b.a("SDKSessionBegin", null);
            n = this.mSession.sessionBegin(this.mContext, null, this);
        }
        catch (SpeechError speechError) {
            speechError.printStackTrace();
            n = speechError.getErrorCode();
            this.mError = speechError;
        }
        finally {
            ++this.mSessionRetryCount;
            if (n == 0 && null != this.mSession.mClientID) {
                this.mIsRestarting = false;
                if (this.mIsFirstSession) {
                    this.mIsFirstSession = false;
                    if (null != this.mListener) {
                        this.mListener.onEvent(10010, 0, 0, null);
                    }
                }
            } else if (this.isRunning()) {
                if (this.isRecordMode()) {
                    this.sendMsg(1, a.a.b, false, 500);
                } else {
                    this.sendMsg(1, a.a.a, false, 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proc_Msg_Record_Data(Message message) throws Exception {
        block13: {
            int n = 0;
            try {
                n = this.getAudioData();
            }
            catch (IOException iOException) {
                com.iflytek.cloud.msc.i.b.a.a(iOException);
                throw new SpeechError(10105, "Read file Error" + iOException.getLocalizedMessage());
            }
            try {
                if (this.isSessionOn()) {
                    if (null != this.mBuffer && n > 0) {
                        this.uploadData(this.mBuffer, n, false);
                        this.mLastMscOffset += n;
                        com.iflytek.cloud.msc.i.b.a.a("LastMscOffset: " + this.mLastMscOffset);
                    }
                    this.updateUploadBytes();
                    this.updateSessionID();
                    this.updateSyncID();
                    this.updateCatchLeft();
                    this.sendMsg(this.obtainMessage(22, null), a.a.b, false, 100);
                }
            }
            catch (SpeechError speechError) {
                this.mError = speechError;
                if (10114 == speechError.getErrorCode()) {
                    this.restartSession();
                    break block13;
                }
                throw speechError;
            }
            finally {
                if (this.hasMoreData()) {
                    this.sendMsg(this.obtainMessage(2, null));
                } else if (this.isSessionOn()) {
                    this.stopWriteAutio();
                }
            }
        }
    }

    public synchronized boolean stopTranscripting(boolean bl) {
        com.iflytek.cloud.msc.i.b.a.a("stopTranscript, current status is :" + (Object)((Object)this.getStatus()) + " usercancel : " + bl);
        this.mPerflog.a("app_stop");
        this.releaseRecord();
        this.mUstopRecord = bl;
        this.sendMsg(3);
        return true;
    }

    private void proc_Msg_Record_Stoped() throws SpeechError, IOException, InterruptedException {
        com.iflytek.cloud.msc.i.b.a.a("recording stop");
        this.releaseRecord();
        this.mPerflog.a("app_lau");
        if (this.mListener != null) {
            this.mListener.onEndOfSpeech();
        }
    }

    @Override
    public void cancel(boolean bl) {
        if (bl && this.isRunning() && this.mListener != null) {
            this.mListener.onError(new SpeechError(20017));
        }
        this.releaseRecord();
        if (this.getStatus() == a.b.c) {
            this.mUstopRecord = true;
        }
        super.cancel(bl);
    }

    public void proc_Msg_Netperf() {
        if (this.isRunning()) {
            int n = this.mSession.getIntValue("netperf");
            if (this.mListener != null) {
                this.mListener.onEvent(10001, n, 0, null);
            }
            this.sendMsg(7, a.a.b, false, 500);
        }
    }

    @Override
    protected void onEnd(SpeechError speechError) {
        block14: {
            com.iflytek.cloud.msc.i.b.a.a("onSessionEnd");
            this.releaseRecord();
            mUpflow = this.mSession.getIntValue("upflow");
            mDownflow = this.mSession.getIntValue("downflow");
            this.getSessionID();
            this.updateUploadBytes();
            this.updateSessionID();
            this.updateSyncID();
            if (null != this.mListener) {
                Bundle bundle = new Bundle();
                bundle.putString("sid", this.mSessionID);
                bundle.putInt("syncid", this.mSyncID);
                bundle.putInt("spos", this.mLastServerOffset);
                bundle.putInt("total", (int)this.getDataLength());
                bundle.putString("ist_audio_path", this.getAudioPath());
                bundle.putSerializable("error", (Serializable)speechError);
                this.mListener.onEvent(10011, 0, 0, bundle);
            }
            try {
                this.closeAudioFile();
            }
            catch (Exception exception) {
                if (null != speechError) break block14;
                speechError = new SpeechError(exception);
            }
        }
        if (this.mResults.size() <= 0 && speechError == null && this.getParam().a("asr_nomatch_error", true)) {
            speechError = new SpeechError(10118);
        }
        if (null != speechError) {
            this.mPerflog.a("app_ret", speechError.getErrorCode(), false);
        } else {
            this.mPerflog.a("app_ret", 0L, false);
        }
        this.mPerflog.a("rec_ustop", this.mUstopRecord ? "1" : "0", false);
        this.mSession.setParam("sessinfo", this.mPerflog.a());
        com.iflytek.cloud.msc.i.b.b.a("SessionEndBegin", null);
        if (this.mUserCancel) {
            this.mSession.sessionEnd("user abort");
        } else if (speechError != null) {
            this.mSession.sessionEnd("error" + speechError.getErrorCode());
        } else {
            this.mSession.sessionEnd("success");
        }
        com.iflytek.cloud.msc.i.b.b.a("SessionEndEnd", null);
        super.onEnd(speechError);
        if (this.mListener != null) {
            if (this.mUserCancel) {
                com.iflytek.cloud.msc.i.b.a.a("TranscripterListener#onCancel");
            } else {
                com.iflytek.cloud.msc.i.b.a.a("TranscripterListener#onEnd");
                if (speechError != null) {
                    this.mListener.onError(speechError);
                }
            }
        }
    }

    private void notifyResult(boolean bl, byte[] byArray) throws SpeechError, UnsupportedEncodingException {
        String string = null;
        this.mStatusBegin = SystemClock.elapsedRealtime();
        if (byArray != null && byArray.length > 0) {
            string = new String(byArray, "utf-8");
        } else if (this.mResults.size() > 0) {
            string = "";
        }
        this.getSessionID();
        this.mResults.add(string);
        if (null != this.mListener && this.isRunning()) {
            TranscripterResult transcripterResult = new TranscripterResult(string);
            com.iflytek.cloud.msc.i.b.b.a("GetNotifyResult", null);
            this.mListener.onResult(transcripterResult, bl);
        }
        com.iflytek.cloud.msc.i.b.a.a("msc result time:" + System.currentTimeMillis());
        if (bl) {
            this.exit(null);
        }
    }

    public TranscripterResult getTranscriptResult() throws SpeechError {
        TranscripterResult transcripterResult = null;
        try {
            if (this.mSession.getResultData() != null) {
                transcripterResult = new TranscripterResult(new String(this.mSession.getResultData(), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            com.iflytek.cloud.msc.i.b.a.a(unsupportedEncodingException);
            throw new SpeechError(20004);
        }
        return transcripterResult;
    }

    @Override
    protected void onParseParam() {
        this.mAudioSource = this.getParam().a("audio_source", 1);
        this.mMaxSessionTry = this.getParam().a("ist_session_try", this.mMaxSessionTry);
        this.mLastMscOffset = this.mLastServerOffset = this.getParam().a("spos", 0);
        this.mSessionID = this.getParam().b("sid", null);
        this.mFilePath = new String(this.getParam().b("ist_audio_path", b.b));
        this.mSyncID = this.getParam().a("syncid", 0);
        super.onParseParam();
    }

    private void releaseRecord() {
        if (this.mRecorder != null) {
            this.mRecorder.stopRecord(this.getParam().a("record_force_stop", false));
            this.mRecorder = null;
            this.mPerflog.a("rec_close");
            try {
                if (null != this.mAccesser) {
                    this.mAccesser.flush();
                }
            }
            catch (Exception exception) {
                this.exit(new SpeechError(exception));
                return;
            }
            this.mSessionRetryCount = 0;
            if (this.mUseBluetooth) {
                this.stopBluetooth();
            }
        }
        this.mIsRecording = false;
    }

    void proc_Msg_Result(Message message) throws SpeechError, InterruptedException, UnsupportedEncodingException {
        int n = message.arg1;
        byte[] byArray = (byte[])message.obj;
        switch (n) {
            case 2: {
                break;
            }
            case 0: {
                if (!this.mFirstDataArrival) {
                    this.mFirstDataArrival = true;
                    this.mPerflog.a("app_frs");
                }
                this.notifyResult(false, byArray);
                break;
            }
            case 5: {
                if (!this.mFirstDataArrival) {
                    this.mFirstDataArrival = true;
                    this.mPerflog.a("app_frs");
                }
                this.mPerflog.a("app_lrs");
                this.notifyResult(true, byArray);
                break;
            }
        }
    }

    protected void uploadData(byte[] byArray, int n, boolean bl) throws SpeechError {
        if (!this.mFirstDataWrite) {
            this.mFirstDataWrite = true;
            this.mPerflog.a("app_fau");
        }
        this.mSession.pushAudioData(byArray, n);
        if (bl) {
            int n2 = this.mSession.getAudioVolume();
            com.iflytek.cloud.msc.i.b.a.b("QISRAudioWrite volume:" + n2);
            this.callbackVolume(byArray, n2);
        }
    }

    @Override
    public void onRecordBuffer(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 <= 0 || byArray.length < n2) {
            return;
        }
        if (n2 > 0 && this.isRunning()) {
            if (!this.mFirstRecordAudio) {
                this.mFirstRecordAudio = true;
                this.mPerflog.a("rec_start");
            }
            try {
                if (this.mAccesser == null) {
                    if (-1 == this.mAudioSource) {
                        this.mAccesser = AudioAccessor.createBufferAccessor();
                    } else if (-2 == this.mAudioSource) {
                        this.mAccesser = AudioAccessor.createReadOnlyAccessor(this.mFilePath);
                        this.getParam().a("sample_rate", this.mAccesser.getAudioInfo(AudioAccessor.AudioKeys.RATE), false);
                    }
                }
                this.mAccesser.putAudio(byArray, n2);
            }
            catch (Exception exception) {
                com.iflytek.cloud.msc.i.b.a.a(exception);
                this.exit(new SpeechError(exception));
                return;
            }
            this.updateCatchLeft();
            if (!this.mIsProcRecordDataOn) {
                this.mIsProcRecordDataOn = true;
                this.sendMsg(this.obtainMessage(2, null));
            }
        }
    }

    @Override
    public void onError(SpeechError speechError) {
        this.exit(speechError);
    }

    @Override
    public void onRecordStarted(boolean bl) {
        this.mPerflog.a("rec_ready");
        this.mIsRecording = bl;
    }

    public c getPerfLog() {
        return this.mPerflog;
    }

    @Override
    public void onRecordReleased() {
    }

    @Override
    public String getSessionID() {
        if (TextUtils.isEmpty((CharSequence)this.mSessionID)) {
            this.mSessionID = this.mSession.getSessionID();
        }
        return this.mSessionID;
    }

    @Override
    public String getClientID() {
        return this.mSession.getClientID();
    }

    private boolean isRecordMode() {
        return -1 != this.mAudioSource && -2 != this.mAudioSource;
    }

    private void assertSessionTimes() throws SpeechError {
        if ((!this.isRecordMode() || this.isRecordMode() && !this.isRecording()) && this.getMaxSessionTry() != -1 && this.getMaxSessionTry() <= this.mSessionRetryCount) {
            com.iflytek.cloud.msc.i.b.a.c("proc_Msg_Session_Begin max session try:" + this.getMaxSessionTry());
            throw new SpeechError(this.mError);
        }
    }

    private boolean isRecording() {
        com.iflytek.cloud.msc.i.b.a.c("isRecording:" + this.mIsRecording);
        return this.mIsRecording;
    }

    private boolean hasMoreData() {
        com.iflytek.cloud.msc.i.b.a.c("hasMoreData >>> isRecording ? " + this.isRecording() + " && datalength == " + this.getDataLength());
        return this.isRecording() || this.getDataLength() > (long)this.mLastMscOffset;
    }

    private synchronized void restartSession() throws SpeechError {
        if (this.mIsRestarting) {
            return;
        }
        this.assertSessionTimes();
        this.updateUploadBytes();
        this.updateSessionID();
        this.updateSyncID();
        this.mSession.sessionEnd("restart");
        this.mLastMscOffset = this.mLastServerOffset;
        this.mSession.mClientID = null;
        if (null != this.mSessionID) {
            this.getParam().a("sid", this.mSessionID);
            this.getParam().a("spos", Integer.toString(this.mLastServerOffset), true);
            this.getParam().a("syncid", Integer.toString(this.mSyncID), true);
        }
        this.sendMsg(1, a.a.a, false, 0);
        this.mIsRestarting = true;
    }

    private int getMaxSessionTry() {
        return this.mMaxSessionTry;
    }

    private long getDataLength() {
        if (null != this.mAccesser) {
            com.iflytek.cloud.msc.i.b.a.a("getDataLength len=" + this.mAccesser.getDataLength());
            return this.mAccesser.getDataLength();
        }
        com.iflytek.cloud.msc.i.b.a.c("getDataLength file accesser is null.");
        return -1L;
    }

    private void closeAudioFile() throws IOException {
        if (null != this.mAccesser) {
            this.mAccesser.close();
            this.mAccesser = null;
        }
    }

    private int getAudioData() throws SpeechError, IOException {
        if (null != this.mAccesser) {
            return this.mAccesser.getAudio(this.mBuffer);
        }
        return 0;
    }

    private boolean isSessionOn() {
        return null != this.mSession.mClientID;
    }

    public int getUploadBytes() {
        return this.mLastServerOffset;
    }

    private void updateSessionID() {
        if (null == this.mSessionID) {
            this.mSessionID = this.getSessionID();
            if (null != this.mSessionID && null != this.mListener) {
                Bundle bundle = new Bundle();
                bundle.putString("session_id", this.mSessionID);
                this.mListener.onEvent(20001, 0, 0, bundle);
            }
        }
    }

    private void updateUploadBytes() {
        int n = this.mSession.getIntValue("spos", this.mLastServerOffset);
        com.iflytek.cloud.msc.i.b.a.d("updateUploadBytes", "uploadLen=" + n);
        if (n != this.mLastServerOffset) {
            this.mLastServerOffset = n;
            if (null != this.mListener) {
                int n2 = -1 == this.getAudioSource() ? (int)this.getDataLength() : -1;
                boolean bl = !this.isRecording() && this.getDataLength() == (long)this.mLastServerOffset;
                Bundle bundle = new Bundle();
                bundle.putBoolean("ist_upload_complete", bl);
                this.mListener.onEvent(10006, n, n2, bundle);
            }
        }
    }

    private void updateCatchLeft() {
        if (!this.isRecordMode() && null != this.mListener && null != this.mAccesser) {
            this.mListener.onEvent(10007, this.mAccesser.getCacheLeft(), 0, null);
        }
    }

    public int getSyncID() {
        return this.mSyncID;
    }

    private void updateSyncID() {
        int n = this.mSession.getIntValue("syncid", this.mSyncID);
        com.iflytek.cloud.msc.i.b.a.d("updateSyncID", "syncid=" + n);
        if (n != this.mSyncID) {
            this.mSyncID = n;
            if (null != this.mListener) {
                this.mListener.onEvent(10009, n, 0, null);
            }
        }
    }

    public String getAudioPath() {
        if (null != this.mAccesser) {
            return this.mAccesser.getFilePath();
        }
        return null;
    }

    private void stopWriteAutio() throws SpeechError {
        this.mSession.pushEndFlag();
        this.sendMsg(this.obtainMessage(32790, null));
    }

    protected void proc_Msg_Wait_Result() throws Exception {
        this.updateUploadBytes();
        this.updateSessionID();
        this.updateSyncID();
        int n = this.mSession.getIntValue(b.a, -1);
        com.iflytek.cloud.msc.i.b.a.a("onWaiting msc waitTime=" + n);
        if (n >= 0 && n != this.mResultSecondLeft) {
            this.mStatusBegin = System.currentTimeMillis();
            this.mResultSecondLeft = n;
            if (null != this.mListener) {
                this.mListener.onEvent(10008, n / 1000, 0, null);
            }
        }
        b.a a2 = b.a.c;
        try {
            a2 = this.requestResult();
        }
        catch (SpeechError speechError) {
            if (10114 == speechError.getErrorCode()) {
                this.restartSession();
            }
            throw speechError;
        }
        if (this.mResultSecondLeft >= 0 || b.a.c != a2) {
            MscTranscripter.timeOutCheck(this.mStatusBegin, this.mResultSecondLeft + this.mNetTimeOut);
        }
        this.sendMsg(32790, a.a.a, false, 500);
    }

    protected b.a requestResult() throws SpeechError, UnsupportedEncodingException {
        String string;
        b.a a2 = this.mSession.getStatus();
        byte[] byArray = null;
        if (b.a.c != a2 && this.mSession.getResultData() != null && this.mSession.getResultData().length > 0) {
            string = new String(this.mSession.getResultData(), "gb2312");
            byArray = string.getBytes("utf-8");
        }
        com.iflytek.cloud.msc.i.b.a.a("result:" + byArray);
        string = this.obtainMessage(4, a2.ordinal(), 0, byArray);
        if (this.hasMessages(4)) {
            this.sendMsg((Message)string, a.a.b, false, 0);
        } else {
            this.sendMsg((Message)string, a.a.a, false, 0);
        }
        return a2;
    }
}

