/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import io.flutter.Log;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import java.util.HashSet;
import java.util.Set;

public class FlutterSurfaceView
extends SurfaceView
implements FlutterRenderer.RenderSurface {
    private static final String TAG = "FlutterSurfaceView";
    private final boolean renderTransparently;
    private boolean isSurfaceAvailableForRendering = false;
    private boolean isAttachedToFlutterRenderer = false;
    @Nullable
    private FlutterRenderer flutterRenderer;
    @NonNull
    private Set<OnFirstFrameRenderedListener> onFirstFrameRenderedListeners = new HashSet<OnFirstFrameRenderedListener>();
    private final SurfaceHolder.Callback surfaceCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(@NonNull SurfaceHolder holder) {
            Log.v(FlutterSurfaceView.TAG, "SurfaceHolder.Callback.surfaceCreated()");
            FlutterSurfaceView.this.isSurfaceAvailableForRendering = true;
            if (FlutterSurfaceView.this.isAttachedToFlutterRenderer) {
                FlutterSurfaceView.this.connectSurfaceToRenderer();
            }
        }

        public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
            Log.v(FlutterSurfaceView.TAG, "SurfaceHolder.Callback.surfaceChanged()");
            if (FlutterSurfaceView.this.isAttachedToFlutterRenderer) {
                FlutterSurfaceView.this.changeSurfaceSize(width, height);
            }
        }

        public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
            Log.v(FlutterSurfaceView.TAG, "SurfaceHolder.Callback.surfaceDestroyed()");
            FlutterSurfaceView.this.isSurfaceAvailableForRendering = false;
            if (FlutterSurfaceView.this.isAttachedToFlutterRenderer) {
                FlutterSurfaceView.this.disconnectSurfaceFromRenderer();
            }
        }
    };

    public FlutterSurfaceView(@NonNull Context context) {
        this(context, null, false);
    }

    public FlutterSurfaceView(@NonNull Context context, boolean renderTransparently) {
        this(context, null, renderTransparently);
    }

    public FlutterSurfaceView(@NonNull Context context, @NonNull AttributeSet attrs) {
        this(context, attrs, false);
    }

    private FlutterSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs, boolean renderTransparently) {
        super(context, attrs);
        this.renderTransparently = renderTransparently;
        this.init();
    }

    private void init() {
        if (this.renderTransparently) {
            this.getHolder().setFormat(-2);
            this.setZOrderOnTop(true);
        }
        this.getHolder().addCallback(this.surfaceCallback);
        this.setAlpha(0.0f);
    }

    @Override
    public void attachToRenderer(@NonNull FlutterRenderer flutterRenderer) {
        Log.v(TAG, "Attaching to FlutterRenderer.");
        if (this.flutterRenderer != null) {
            Log.v(TAG, "Already connected to a FlutterRenderer. Detaching from old one and attaching to new one.");
            this.flutterRenderer.detachFromRenderSurface();
        }
        this.flutterRenderer = flutterRenderer;
        this.isAttachedToFlutterRenderer = true;
        if (this.isSurfaceAvailableForRendering) {
            Log.v(TAG, "Surface is available for rendering. Connecting FlutterRenderer to Android surface.");
            this.connectSurfaceToRenderer();
        }
    }

    @Override
    public void detachFromRenderer() {
        if (this.flutterRenderer != null) {
            if (this.getWindowToken() != null) {
                Log.v(TAG, "Disconnecting FlutterRenderer from Android surface.");
                this.disconnectSurfaceFromRenderer();
            }
            this.setAlpha(0.0f);
            this.flutterRenderer = null;
            this.isAttachedToFlutterRenderer = false;
        } else {
            Log.w(TAG, "detachFromRenderer() invoked when no FlutterRenderer was attached.");
        }
    }

    private void connectSurfaceToRenderer() {
        if (this.flutterRenderer == null || this.getHolder() == null) {
            throw new IllegalStateException("connectSurfaceToRenderer() should only be called when flutterRenderer and getHolder() are non-null.");
        }
        this.flutterRenderer.surfaceCreated(this.getHolder().getSurface());
    }

    private void changeSurfaceSize(int width, int height) {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("changeSurfaceSize() should only be called when flutterRenderer is non-null.");
        }
        Log.v(TAG, "Notifying FlutterRenderer that Android surface size has changed to " + width + " x " + height);
        this.flutterRenderer.surfaceChanged(width, height);
    }

    private void disconnectSurfaceFromRenderer() {
        if (this.flutterRenderer == null) {
            throw new IllegalStateException("disconnectSurfaceFromRenderer() should only be called when flutterRenderer is non-null.");
        }
        this.flutterRenderer.surfaceDestroyed();
    }

    @Override
    public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.onFirstFrameRenderedListeners.add(listener);
    }

    @Override
    public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.onFirstFrameRenderedListeners.remove(listener);
    }

    @Override
    public void onFirstFrameRendered() {
        Log.v(TAG, "onFirstFrameRendered()");
        this.setAlpha(1.0f);
        for (OnFirstFrameRenderedListener listener : this.onFirstFrameRenderedListeners) {
            listener.onFirstFrameRendered();
        }
    }
}

