/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import android.support.annotation.NonNull;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocalizationChannel {
    private static final String TAG = "LocalizationChannel";
    @NonNull
    public final MethodChannel channel;

    public LocalizationChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/localization", JSONMethodCodec.INSTANCE);
    }

    public void sendLocales(@NonNull List<Locale> locales) {
        Log.v(TAG, "Sending Locales to Flutter.");
        ArrayList<String> data = new ArrayList<String>();
        for (Locale locale : locales) {
            Log.v(TAG, "Locale (Language: " + locale.getLanguage() + ", Country: " + locale.getCountry() + ", Variant: " + locale.getVariant() + ")");
            data.add(locale.getLanguage());
            data.add(locale.getCountry());
            data.add(Build.VERSION.SDK_INT >= 21 ? locale.getScript() : "");
            data.add(locale.getVariant());
        }
        this.channel.invokeMethod("setLocale", data);
    }
}

