/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.renderer;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import io.flutter.view.TextureRegistry;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=16)
public class FlutterRenderer
implements TextureRegistry {
    private static final String TAG = "FlutterRenderer";
    private final FlutterJNI flutterJNI;
    private final AtomicLong nextTextureId = new AtomicLong(0L);
    private RenderSurface renderSurface;
    private boolean hasRenderedFirstFrame = false;
    private final OnFirstFrameRenderedListener onFirstFrameRenderedListener = new OnFirstFrameRenderedListener(){

        @Override
        public void onFirstFrameRendered() {
            FlutterRenderer.this.hasRenderedFirstFrame = true;
        }
    };

    public FlutterRenderer(@NonNull FlutterJNI flutterJNI) {
        this.flutterJNI = flutterJNI;
        this.flutterJNI.addOnFirstFrameRenderedListener(this.onFirstFrameRenderedListener);
    }

    public boolean isAttachedTo(@NonNull RenderSurface renderSurface) {
        return this.renderSurface == renderSurface;
    }

    public void attachToRenderSurface(@NonNull RenderSurface renderSurface) {
        Log.v(TAG, "Attaching to RenderSurface.");
        if (this.renderSurface != null) {
            Log.v(TAG, "Already attached to a RenderSurface. Detaching from old one and attaching to new one.");
            this.detachFromRenderSurface();
        }
        this.renderSurface = renderSurface;
        this.renderSurface.attachToRenderer(this);
        this.flutterJNI.setRenderSurface(renderSurface);
    }

    public void detachFromRenderSurface() {
        Log.v(TAG, "Detaching from RenderSurface.");
        if (this.renderSurface != null) {
            this.renderSurface.detachFromRenderer();
            this.renderSurface = null;
            this.surfaceDestroyed();
            this.flutterJNI.setRenderSurface(null);
        }
    }

    public boolean hasRenderedFirstFrame() {
        return this.hasRenderedFirstFrame;
    }

    public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.flutterJNI.addOnFirstFrameRenderedListener(listener);
        if (this.hasRenderedFirstFrame) {
            listener.onFirstFrameRendered();
        }
    }

    public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.flutterJNI.removeOnFirstFrameRenderedListener(listener);
    }

    @Override
    @TargetApi(value=16)
    public TextureRegistry.SurfaceTextureEntry createSurfaceTexture() {
        Log.v(TAG, "Creating a SurfaceTexture.");
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.detachFromGLContext();
        SurfaceTextureRegistryEntry entry = new SurfaceTextureRegistryEntry(this.nextTextureId.getAndIncrement(), surfaceTexture);
        Log.v(TAG, "New SurfaceTexture ID: " + entry.id());
        this.registerTexture(entry.id(), surfaceTexture);
        return entry;
    }

    public void surfaceCreated(@NonNull Surface surface) {
        this.flutterJNI.onSurfaceCreated(surface);
    }

    public void surfaceChanged(int width, int height) {
        this.flutterJNI.onSurfaceChanged(width, height);
    }

    public void surfaceDestroyed() {
        this.flutterJNI.onSurfaceDestroyed();
    }

    public void setViewportMetrics(@NonNull ViewportMetrics viewportMetrics) {
        Log.v(TAG, "Setting viewport metrics\nSize: " + viewportMetrics.width + " x " + viewportMetrics.height + "\nPadding - L: " + viewportMetrics.paddingLeft + ", T: " + viewportMetrics.paddingTop + ", R: " + viewportMetrics.paddingRight + ", B: " + viewportMetrics.paddingBottom + "\nInsets - L: " + viewportMetrics.viewInsetLeft + ", T: " + viewportMetrics.viewInsetTop + ", R: " + viewportMetrics.viewInsetRight + ", B: " + viewportMetrics.viewInsetBottom + "\nSystem Gesture Insets - L: " + viewportMetrics.systemGestureInsetLeft + ", T: " + viewportMetrics.systemGestureInsetTop + ", R: " + viewportMetrics.systemGestureInsetRight + ", B: " + viewportMetrics.viewInsetBottom);
        this.flutterJNI.setViewportMetrics(viewportMetrics.devicePixelRatio, viewportMetrics.width, viewportMetrics.height, viewportMetrics.paddingTop, viewportMetrics.paddingRight, viewportMetrics.paddingBottom, viewportMetrics.paddingLeft, viewportMetrics.viewInsetTop, viewportMetrics.viewInsetRight, viewportMetrics.viewInsetBottom, viewportMetrics.viewInsetLeft, viewportMetrics.systemGestureInsetTop, viewportMetrics.systemGestureInsetRight, viewportMetrics.systemGestureInsetBottom, viewportMetrics.systemGestureInsetLeft);
    }

    public Bitmap getBitmap() {
        return this.flutterJNI.getBitmap();
    }

    public void dispatchPointerDataPacket(@NonNull ByteBuffer buffer, int position) {
        this.flutterJNI.dispatchPointerDataPacket(buffer, position);
    }

    private void registerTexture(long textureId, @NonNull SurfaceTexture surfaceTexture) {
        this.flutterJNI.registerTexture(textureId, surfaceTexture);
    }

    private void markTextureFrameAvailable(long textureId) {
        this.flutterJNI.markTextureFrameAvailable(textureId);
    }

    private void unregisterTexture(long textureId) {
        this.flutterJNI.unregisterTexture(textureId);
    }

    public boolean isSoftwareRenderingEnabled() {
        return FlutterJNI.nativeGetIsSoftwareRenderingEnabled();
    }

    public void setAccessibilityFeatures(int flags) {
        this.flutterJNI.setAccessibilityFeatures(flags);
    }

    public void setSemanticsEnabled(boolean enabled) {
        this.flutterJNI.setSemanticsEnabled(enabled);
    }

    public void dispatchSemanticsAction(int id, int action, @Nullable ByteBuffer args, int argsPosition) {
        this.flutterJNI.dispatchSemanticsAction(id, action, args, argsPosition);
    }

    public static final class ViewportMetrics {
        public float devicePixelRatio = 1.0f;
        public int width = 0;
        public int height = 0;
        public int paddingTop = 0;
        public int paddingRight = 0;
        public int paddingBottom = 0;
        public int paddingLeft = 0;
        public int viewInsetTop = 0;
        public int viewInsetRight = 0;
        public int viewInsetBottom = 0;
        public int viewInsetLeft = 0;
        public int systemGestureInsetTop = 0;
        public int systemGestureInsetRight = 0;
        public int systemGestureInsetBottom = 0;
        public int systemGestureInsetLeft = 0;
    }

    public static interface RenderSurface {
        public void attachToRenderer(@NonNull FlutterRenderer var1);

        public void detachFromRenderer();

        public void onFirstFrameRendered();

        public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener var1);

        public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener var1);
    }

    final class SurfaceTextureRegistryEntry
    implements TextureRegistry.SurfaceTextureEntry {
        private final long id;
        @NonNull
        private final SurfaceTexture surfaceTexture;
        private boolean released;
        private SurfaceTexture.OnFrameAvailableListener onFrameListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(@NonNull SurfaceTexture texture) {
                if (SurfaceTextureRegistryEntry.this.released) {
                    return;
                }
                FlutterRenderer.this.markTextureFrameAvailable(SurfaceTextureRegistryEntry.this.id);
            }
        };

        SurfaceTextureRegistryEntry(@NonNull long id, SurfaceTexture surfaceTexture) {
            this.id = id;
            this.surfaceTexture = surfaceTexture;
            if (Build.VERSION.SDK_INT >= 21) {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener, new Handler());
            } else {
                this.surfaceTexture.setOnFrameAvailableListener(this.onFrameListener);
            }
        }

        @Override
        @NonNull
        public SurfaceTexture surfaceTexture() {
            return this.surfaceTexture;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public void release() {
            if (this.released) {
                return;
            }
            Log.v(FlutterRenderer.TAG, "Releasing a SurfaceTexture (" + this.id + ").");
            this.surfaceTexture.release();
            FlutterRenderer.this.unregisterTexture(this.id);
            this.released = true;
        }
    }
}

